<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Casino_Theme
 */

?>

<footer class="footer">
        <div class="footer__menu_side">
          <div class="footer__container">
            <div class="footer__logo_block">
              <?php
              // Получаем логотип из настроек темы
              $footer_logo_data = casino_get_footer_logo();
              $logo_url = $footer_logo_data['url'];
              $logo_alt = $footer_logo_data['alt'];
              ?>
              <a class="footer__logo" href="<?php echo esc_url(home_url('/')); ?>">
                <img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr($logo_alt); ?>">
              </a>
              <div class="footer__soc_heading">
                <span><?php pll_e('follow_us'); ?></span>
              </div>
              <div class="footer__soc_items">
              <?php
              // Получаем соц.сети из настроек темы
              $social_networks = casino_get_social_networks();
              if ($social_networks) :
                  foreach ($social_networks as $network) :
                      $name = isset($network['name']) ? $network['name'] : '';
                      $url = isset($network['url']) ? $network['url'] : '#';
                      $icon = isset($network['icon']['url']) ? $network['icon']['url'] : '';
                      $class = strtolower($name);
              ?>
                      <a class="footer__soc_item <?php echo esc_attr($class); ?>" href="<?php echo esc_url($url); ?>">
                          <?php if ($icon) : ?>
                              <img src="<?php echo esc_url($icon); ?>" alt="<?php echo esc_attr($name); ?>">
                          <?php else : ?>
                              <span><?php echo esc_html($name); ?></span>
                          <?php endif; ?>
                      </a>
              <?php
                  endforeach;
              else : // Если соц.сети не настроены, показываем дефолтные
              ?>
                  <a class="footer__soc_item" href="/"><svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path fill-rule="evenodd" clip-rule="evenodd" d="M9 18C13.9707 18 18 13.9707 18 9C18 4.0293 13.9707 0 9 0C4.0293 0 0 4.0293 0 9C0 13.9707 4.0293 18 9 18ZM7.8534 9.819L3.8826 4.5H6.9426L9.5463 7.9866L12.7683 4.5H13.6683L9.9477 8.5248L14.1426 14.1426H11.0826L8.2557 10.3572L4.7565 14.1426H3.8565L7.8534 9.819ZM6.6114 5.1642H5.2047L11.4147 13.4793H12.8196L6.6114 5.1642Z"/>
                  </svg></a>
                  <a class="footer__soc_item instagram" href="/">
                  <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path fill-rule="evenodd" clip-rule="evenodd" d="M12 18C15.3137 18 18 15.3137 18 12C18 8.68629 15.3137 6 12 6C8.68629 6 6 8.68629 6 12C6 15.3137 8.68629 18 12 18ZM12 16C14.2091 16 16 14.2091 16 12C16 9.79086 14.2091 8 12 8C9.79086 8 8 9.79086 8 12C8 14.2091 9.79086 16 12 16Z" />
                  <path d="M18 5C17.4477 5 17 5.44772 17 6C17 6.55228 17.4477 7 18 7C18.5523 7 19 6.55228 19 6C19 5.44772 18.5523 5 18 5Z" />
                  <path fill-rule="evenodd" clip-rule="evenodd" d="M1.65396 4.27606C1 5.55953 1 7.23969 1 10.6V13.4C1 16.7603 1 18.4405 1.65396 19.7239C2.2292 20.8529 3.14708 21.7708 4.27606 22.346C5.55953 23 7.23969 23 10.6 23H13.4C16.7603 23 18.4405 23 19.7239 22.346C20.8529 21.7708 21.7708 20.8529 22.346 19.7239C23 18.4405 23 16.7603 23 13.4V10.6C23 7.23969 23 5.55953 22.346 4.27606C21.7708 3.14708 20.8529 2.2292 19.7239 1.65396C18.4405 1 16.7603 1 13.4 1H10.6C7.23969 1 5.55953 1 4.27606 1.65396C3.14708 2.2292 2.2292 3.14708 1.65396 4.27606ZM13.4 3H10.6C8.88684 3 7.72225 3.00156 6.82208 3.0751C5.94524 3.14674 5.49684 3.27659 5.18404 3.43597C4.43139 3.81947 3.81947 4.43139 3.43597 5.18404C3.27659 5.49684 3.14674 5.94524 3.0751 6.82208C3.00156 7.72225 3 8.88684 3 10.6V13.4C3 15.1132 3.00156 16.2777 3.0751 17.1779C3.14674 18.0548 3.27659 18.5032 3.43597 18.816C3.81947 19.5686 4.43139 20.1805 5.18404 20.564C5.49684 20.7234 5.94524 20.8533 6.82208 20.9249C7.72225 20.9984 8.88684 21 10.6 21H13.4C15.1132 21 16.2777 20.9984 17.1779 20.9249C18.0548 20.8533 18.5032 20.7234 18.816 20.564C19.5686 20.1805 20.1805 19.5686 20.564 18.816C20.7234 18.5032 20.8533 18.0548 20.9249 17.1779C20.9984 16.2777 21 15.1132 21 13.4V10.6C21 8.88684 20.9984 7.72225 20.9249 6.82208C20.8533 5.94524 20.7234 5.49684 20.564 5.18404C20.1805 4.43139 19.5686 3.81947 18.816 3.43597C18.5032 3.27659 18.0548 3.14674 17.1779 3.0751C16.2777 3.00156 15.1132 3 13.4 3Z" /></svg></a>
                  <a class="footer__soc_item" href="/"><svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M9 0C4.032 0 0 4.032 0 9C0 13.968 4.032 18 9 18C13.968 18 18 13.968 18 9C18 4.032 13.968 0 9 0ZM10.098 16.65V11.142H12.195L12.528 9.009H10.107V7.857C10.107 6.975 10.395 6.183 11.223 6.183H12.555V4.329C12.321 4.293 11.826 4.23 10.89 4.23C8.937 4.23 7.794 5.256 7.794 7.605V9.018H5.787V11.151H7.794V16.641C4.095 16.047 1.26 12.852 1.26 9C1.26 4.734 4.734 1.26 9 1.26C13.266 1.26 16.74 4.734 16.74 9C16.74 12.897 13.842 16.119 10.098 16.65Z"/>
                  </svg></a>
              <?php endif; ?>
              </div>
              <div class="footer__soc_subheading">
                <span><?php pll_e('base_footer_name'); ?></span>
              </div>
            </div>
            <div class="footer__menu_block">
              <?php
              // Получаем меню футера из настроек темы
              $footer_menu_items = casino_get_footer_menu_items();
              
              // Разделяем список на 4 колонки (или меньше, если меньше элементов)
              if ($footer_menu_items && is_array($footer_menu_items)) :
                  $total = count($footer_menu_items);
                  $columns = 4; // Количество колонок
                  $per_column = ceil($total / $columns);
                  
                  for ($i = 0; $i < min($columns, $total); $i++) :
                      echo '<div class="footer__menu">';
                      for ($j = $i * $per_column; $j < min(($i + 1) * $per_column, $total); $j++) :
                          if (isset($footer_menu_items[$j])) :
                              $item = $footer_menu_items[$j];
                              $title = isset($item['title']) ? $item['title'] : '';
                              $url = isset($item['url']) ? $item['url'] : '#';
                  ?>
                              <a class="footer__menu_item" href="<?php echo esc_url($url); ?>"><span><?php echo esc_html($title); ?></span></a>
                  <?php
                          endif;
                      endfor;
                      echo '</div>';
                  endfor;
              else : // Если меню не настроено, показываем дефолтное
              ?>
                  <div class="footer__menu"><a class="footer__menu_item" href="/"><span>Promotions</span></a><a class="footer__menu_item" href="/"><span>About us</span></a><a class="footer__menu_item" href="/"><span>About BTC</span></a><a class="footer__menu_item" href="/"><span>Terms & Conditions</span></a></div>
                  <div class="footer__menu"><a class="footer__menu_item" href="/"><span>Responsible Gaming</span></a><a class="footer__menu_item" href="/"><span>Self-Exclusion</span></a><a class="footer__menu_item" href="/"><span>Dispute Resolution</span></a><a class="footer__menu_item" href="/"><span>AML Policy</span></a></div>
                  <div class="footer__menu"><a class="footer__menu_item" href="/"><span>Fairness & RNG Testing Methods</span></a><a class="footer__menu_item" href="/"><span>KYC Policies</span></a><a class="footer__menu_item" href="/"><span>Privacy Policy</span></a><a class="footer__menu_item" href="/"><span>Accounts, Payouts, and Bonuses</span></a></div>
                  <div class="footer__menu"><a class="footer__menu_item" href="/"><span>FAQ</span></a><a class="footer__menu_item" href="/"><span>Sport Betting Terms</span></a><a class="footer__menu_item" href="/"><span>Affiliates</span></a></div>
              <?php endif; ?>
            </div>
            <div class="footer__contactus_block">
              <div class="footer__soc_subheading">
                <span><?php pll_e('need_help'); ?></span>
              </div>
              <?php
              // Получаем контактный email из настроек темы
              $email = casino_get_footer_email('support_cr@bdmbet.com');
              
              // Получаем текст футера из настроек темы
              $footer_text = casino_get_footer_text();
              ?>
              <div class="footer__contactus_text">
                <?php if ($footer_text) : ?>
                  <?php echo wpautop($footer_text); ?>
                <?php endif; ?>
              </div>
              <a class="footer__email" href="mailto:<?php echo esc_attr($email); ?>"><img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/mail.svg" alt=""><span><?php echo esc_html($email); ?></span></a>
            </div>
          </div>
        </div>
        <div class="footer__copyrights"> <a class="footer__app" href="/"><img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/footer/phone.png" alt=""><span>Casino App</span></a>
          <div class="footer__age"> <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/footer/aged.svg" alt=""></div>
          <div class="footer__paymetns">
            <?php
            // Получаем изображения футера из настроек темы
            $footer_images = casino_get_footer_images();
            
            if ( ! empty( $footer_images ) ) {
                foreach ( $footer_images as $image ) {
                    if ( ! empty( $image['url'] ) ) {
                        ?>
                        <div class="footer__paymetn_item">
                            <img src="<?php echo esc_url( $image['url'] ); ?>" alt="<?php echo esc_attr( $image['alt'] ); ?>">
                        </div>
                        <?php
                    }
                }
            } 
            ?>
          </div>
          <div class="footer__lang_block"> 
          <div class="header__lang">
              <?php if (function_exists('pll_the_languages')): 
                $current_lang = pll_current_language();
                $languages = pll_the_languages(array('raw' => 1));
                
                // Get current language data
                $current_lang_data = isset($languages[$current_lang]) ? $languages[$current_lang] : false;
                $current_lang_code = $current_lang;
                $current_lang_name = $current_lang_data ? $current_lang_data['name'] : 'EN';
                
                // Language flag mapping
                $lang_flags = [
                  'en' => 'uk',
                  'de' => 'de',
                  'es' => 'es',
                  'fr' => 'fr',
                  'it' => 'it',
                  'pt' => 'pt',
                ];
              ?>
              <div class="header__lang_item header__lang_item--active data-toggle">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/flags/<?php echo isset($lang_flags[strtolower($current_lang_code)]) ? $lang_flags[strtolower($current_lang_code)] : 'uk'; ?>.svg" alt="<?php echo esc_attr($current_lang_name); ?>">
                <img class="arrow" src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-down-white.svg" alt="">
              </div>
              <div class="header__lang_hidden">
                <?php foreach ($languages as $lang_code => $lang): 
                  if ($lang_code !== $current_lang): 
                    $flag_code = isset($lang_flags[strtolower($lang_code)]) ? $lang_flags[strtolower($lang_code)] : 'uk';
                ?>
                <a class="header__lang_item data-toggle-item" href="<?php echo esc_url($lang['url']); ?>">
                  <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/flags/<?php echo $flag_code; ?>.svg" alt="<?php echo esc_attr($lang['name']); ?>">
                </a>
                <?php endif; endforeach; ?>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </footer>
    </div>

<?php wp_footer(); ?>

<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/assets/public/js/main.min.js"></script>

</body>
</html>
