<?php
/*
Template Name: Main Page
*/
?>

<?php get_header(); ?>

<section class="main" id="main">
    <div class="main__image_bg"> 
        <?php 
        // Get banner image
        $banner_bg = get_field('main_banner_bg_b2');
        // Set default alt text
        $image_alt = get_bloginfo('name');
        
        // If the image is returned as an array (when return_format is array or id)
        if (is_array($banner_bg) && isset($banner_bg['url'])) {
            $image_url = $banner_bg['url'];
            // Use the alt text if provided in the array
            if (!empty($banner_bg['alt'])) {
                $image_alt = $banner_bg['alt'];
            }
        } 
        // If image is returned as a URL string (when return_format is url)
        else if (is_string($banner_bg)) {
            $image_url = $banner_bg;
            // Try to get attachment ID from URL to extract alt text
            $attachment_id = attachment_url_to_postid($banner_bg);
            if ($attachment_id) {
                $alt_from_media = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
                if (!empty($alt_from_media)) {
                    $image_alt = $alt_from_media;
                }
            }
        }
        
        $static_attr = get_static_image_attr();
        ?>
        <img src="<?php echo esc_url(isset($image_url) ? $image_url : $banner_bg); ?>" alt="<?php echo esc_attr($image_alt); ?>" title="<?php echo esc_attr($static_attr['title']); ?>">
    </div>
    <div class="main__image_players"> 
        <?php $players_image = get_field('main_banner_players_b2'); ?>
        <img src="<?php echo esc_url($players_image['url']); ?>" alt="<?php echo esc_attr($players_image['alt']); ?>">
    </div>
    <div class="main__container">
        <div class="main__text_block">
            <div class="main__rating"> <span><?php pll_e('Overall Rating:'); ?> <b><?php the_field('main_rating_b2'); ?></b></span></div>
            <div class="main__heading"> 
                <h1><?php the_field('main_heading_b2'); ?></h1>
            </div>
            <div class="main__subheading">
                <p><?php the_field('main_subheading_b2'); ?></p>
            </div>
            <a href="<?php echo esc_url(casino_b2_get_global_button_url()); ?>" class="main-btn"> <span><?php pll_e('Get Bonus'); ?></span></a>
        </div>
    </div>
</section>

<section class="content">
    <div class="content__container">
        <div class="sidebar show-item active">
            <?php $sidebar_arrow_attr = get_static_image_attr(); ?>
            <div class="sidebar__heading"><span><?php pll_e('In this review'); ?></span><img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/wide-arrow-bottom-yellow.svg" alt="<?php echo esc_attr($sidebar_arrow_attr['alt']); ?>" title="<?php echo esc_attr($sidebar_arrow_attr['title']); ?>"></div>
            <div class="sidebar__items show-text active" style="height: 0px;">
                <?php
                $id_counter = 1;
                if( have_rows('main_content_b2') ):
                    while( have_rows('main_content_b2') ): the_row();
                        $heading = get_sub_field('heading');
                        if ($heading) {
                            if (get_row_layout() == 'faq_block') {
                                echo '<a class="sidebar__item" href="#questions"><span>' . esc_html($heading) . '</span></a>';
                            } else {
                                echo '<a class="sidebar__item" href="#' . $id_counter . '"><span>' . esc_html($heading) . '</span></a>';
                                $id_counter++;
                            }
                        }
                    endwhile;
                    reset_rows();
                endif;
                ?>
            </div>
        </div>
        <div class="content__items">
            <?php
            if (have_rows('main_content_b2')):
                $id_counter = 1;
                while (have_rows('main_content_b2')) : the_row();
                    if (get_row_layout() == 'intro_text_block') :
                        $content_block = get_sub_field('content');
                        $content_block = preg_replace_callback('/<h2(.*?)>(.*?)<\/h2>/', function($matches) use (&$id_counter) {
                            return '<h2 id="a' . $id_counter++ . '"' . $matches[1] . '>' . $matches[2] . '</h2>';
                        }, $content_block);
                        echo '<div class="content__item"><div class="text-part">' . $content_block . '</div></div>';
                    elseif (get_row_layout() == 'games_block') :
                        ?>
                        <div class="content__item">
                            <div class="games">
                                <div class="games__heading"><h2 id="a<?php echo $id_counter++; ?>"><?php the_sub_field('heading'); ?></h2></div>
                                <div class="games__items">
                                    <?php while(have_rows('games')) : the_row(); 
                                        $game_image = get_sub_field('image');
                                    ?>
                                    <div class="games__item">
                                        <div class="games__image"><img src="<?php echo esc_url($game_image['url']); ?>" alt="<?php echo esc_attr($game_image['alt']); ?>"></div>
                                        <div class="games__name"><span><?php the_sub_field('name'); ?></span></div>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    elseif (get_row_layout() == 'text_image_block') :
                        $ti_image = get_sub_field('image');
                        $show_button = get_sub_field('show_button');
                        ?>
                        <div class="content__item">
                            <div class="text-part">
                                <h2 id="a<?php echo $id_counter++; ?>"><?php the_sub_field('heading'); ?></h2>
                                <?php if ($ti_image) : ?>
                                    <img src="<?php echo esc_url($ti_image['url']); ?>" alt="<?php echo esc_attr($ti_image['alt']); ?>">
                                <?php endif; ?>
                                <?php the_sub_field('content'); ?>
                                <?php if ($show_button) : ?>
                                    <a href="<?php echo esc_url(casino_b2_get_global_button_url()); ?>" class="main-btn"><span><?php pll_e('Get Bonus'); ?></span></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php
                    elseif (get_row_layout() == 'faq_block') :
                        ?>
                        <div class="content__item" id="questions">
                            <div class="questions">
                                <div class="questions__heading"><h2><?php the_sub_field('heading'); ?></h2></div>
                                <div class="questions__items">
                                    <?php while(have_rows('items')) : the_row(); ?>
                                    <div class="questions__item show-item">
                                        <?php $question_arrow_attr = get_static_image_attr(); ?>
                                        <div class="questions__item_heading">
                                            <span><?php the_sub_field('question'); ?></span>
                                            <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-bottom.svg" alt="<?php echo esc_attr($question_arrow_attr['alt']); ?>" title="<?php echo esc_attr($question_arrow_attr['title']); ?>">
                                        </div>
                                        <div class="questions__item_text show-text">
                                            <?php the_sub_field('answer'); ?>
                                        </div>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    elseif (get_row_layout() == 'list_type_1_block') :
                        $lt1_heading = get_sub_field('heading');
                        $lt1_button = get_sub_field('button');
                        ?>
                        <div class="content__item">
                            <div class="list-type-1">
                                <?php if ($lt1_heading) : ?>
                                <div class="list-type-1__heading">
                                    <h2 id="a<?php echo $id_counter++; ?>"><?php echo esc_html($lt1_heading); ?></h2>
                                </div>
                                <?php endif; ?>
                                <div class="list-type-1__items">
                                    <div class="list-type-1__column">
                                        <?php if (have_rows('left_column_items')) : ?>
                                            <?php while (have_rows('left_column_items')) : the_row();
                                                $title = get_sub_field('title');
                                                $description = get_sub_field('description');
                                                $is_type_2 = get_sub_field('is_type_2');
                                                $item_class = $is_type_2 ? 'list-type-1__item type-2' : 'list-type-1__item';
                                            ?>
                                            <div class="<?php echo $item_class; ?>">
                                                <?php if ($title) : ?>
                                                <div class="list-type-1__text"><span><?php echo esc_html($title); ?></span></div>
                                                <?php endif; ?>
                                                <?php if ($description) : ?>
                                                <div class="list-type-1__text"><span><?php echo esc_html($description); ?></span></div>
                                                <?php endif; ?>
                                            </div>
                                            <?php endwhile; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="list-type-1__column">
                                        <?php if (have_rows('right_column_items')) : ?>
                                            <?php while (have_rows('right_column_items')) : the_row();
                                                $title = get_sub_field('title');
                                                $description = get_sub_field('description');
                                                $is_type_2 = get_sub_field('is_type_2');
                                                $item_class = $is_type_2 ? 'list-type-1__item type-2' : 'list-type-1__item';
                                            ?>
                                            <div class="<?php echo $item_class; ?>">
                                                <?php if ($title) : ?>
                                                <div class="list-type-1__text"><span><?php echo esc_html($title); ?></span></div>
                                                <?php endif; ?>
                                                <?php if ($description) : ?>
                                                <div class="list-type-1__text"><span><?php echo esc_html($description); ?></span></div>
                                                <?php endif; ?>
                                            </div>
                                            <?php endwhile; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php if ($lt1_button && !empty($lt1_button['text']) && !empty($lt1_button['url'])) : ?>
                                    <a href="<?php echo esc_url($lt1_button['url']); ?>" class="main-btn"><span><?php echo esc_html($lt1_button['text']); ?></span></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php
                    endif;
                endwhile;
            endif;
            ?>
        </div>
    </div>
    <?php $top_button_attr = get_static_image_attr(); ?>
    <a class="content__arr_top" href="#backTop"><img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/content/top-btn.png" alt="<?php echo esc_attr($top_button_attr['alt']); ?>" title="<?php echo esc_attr($top_button_attr['title']); ?>"></a>
</section>

<?php get_footer(); ?>
