<?php
/**
 * Theme Settings ACF Fields for Base Theme 2
 */

function register_language_specific_theme_settings_b2() {
    if (!function_exists('acf_add_local_field_group') || !function_exists('pll_languages_list')) {
        return;
    }

    $languages = pll_languages_list();
    if (empty($languages)) {
        return;
    }

    foreach ($languages as $lang_slug) {
        acf_add_local_field_group([
            'key' => 'group_theme_settings_b2_' . $lang_slug,
            'title' => 'Theme Settings (' . strtoupper($lang_slug) . ')',
            'fields' => get_theme_settings_fields_for_lang_b2($lang_slug),
            'location' => [
                [
                    [
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'theme-settings-' . $lang_slug,
                    ],
                ],
            ],
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
        ]);
    }
}
add_action('acf/init', 'register_language_specific_theme_settings_b2');

function get_theme_settings_fields_for_lang_b2($lang_slug) {
    return [
        // Header Tab
        [
            'key' => 'field_header_tab_b2_' . $lang_slug,
            'label' => 'Header',
            'type' => 'tab',
        ],
        [
            'key' => 'field_header_logo_b2_' . $lang_slug,
            'label' => 'Header Logo',
            'name' => 'header_logo_b2_' . $lang_slug,
            'type' => 'image',
            'return_format' => 'array',
        ],
        [
            'key' => 'field_header_menu_b2_' . $lang_slug,
            'label' => 'Header Menu',
            'name' => 'header_menu_b2_' . $lang_slug,
            'type' => 'repeater',
            'sub_fields' => get_menu_sub_fields_b2($lang_slug, 'header'),
        ],

        // Footer Tab
        [
            'key' => 'field_footer_tab_b2_' . $lang_slug,
            'label' => 'Footer',
            'type' => 'tab',
        ],
        [
            'key' => 'field_footer_menu_b2_' . $lang_slug,
            'label' => 'Footer Menu',
            'name' => 'footer_menu_b2_' . $lang_slug,
            'type' => 'repeater',
            'sub_fields' => [
                ['key' => 'field_footer_link_title_b2_' . $lang_slug, 'label' => 'Title', 'name' => 'title', 'type' => 'text'],
                ['key' => 'field_footer_link_url_b2_' . $lang_slug, 'label' => 'URL', 'name' => 'url', 'type' => 'text'],
            ],
        ],
        [
            'key' => 'field_footer_payments_b2_' . $lang_slug,
            'label' => 'Payment Icons',
            'name' => 'footer_payments_b2_' . $lang_slug,
            'type' => 'repeater',
            'sub_fields' => [
                [
                    'key' => 'field_footer_payment_image_b2_' . $lang_slug,
                    'label' => 'Image',
                    'name' => 'image',
                    'type' => 'image',
                    'return_format' => 'array',
                ],
            ],
        ],
        [
            'key' => 'field_footer_copyright_img_b2_' . $lang_slug,
            'label' => 'Copyright Image',
            'name' => 'footer_copyright_img_b2_' . $lang_slug,
            'type' => 'image',
            'return_format' => 'url',
        ],
        [
            'key' => 'field_footer_copyright_text_b2_' . $lang_slug,
            'label' => 'Copyright Text',
            'name' => 'footer_copyright_text_b2_' . $lang_slug,
            'type' => 'text',
        ],

        // Global Button Settings
        [
            'key' => 'field_global_button_tab_b2_' . $lang_slug,
            'label' => 'Global Button Settings',
            'type' => 'tab',
        ],
        [
            'key' => 'field_global_button_url_b2_' . $lang_slug,
            'label' => 'Button URL',
            'name' => 'global_button_url_b2_' . $lang_slug,
            'type' => 'text',
        ],
        
        // Static Images Settings Tab
        [
            'key' => 'field_static_images_tab_b2_' . $lang_slug,
            'label' => 'Static Images Settings',
            'type' => 'tab',
        ],
        // Global static image alt text
        [
            'key' => 'field_static_images_alt_b2_' . $lang_slug,
            'label' => 'Static Images Alt Text',
            'name' => 'static_images_alt_b2_' . $lang_slug,
            'type' => 'text',
            'instructions' => 'Default alt text for all static images',
            'default_value' => get_bloginfo('name'),
        ],
        // Global static image title
        [
            'key' => 'field_static_images_title_b2_' . $lang_slug,
            'label' => 'Static Images Title',
            'name' => 'static_images_title_b2_' . $lang_slug,
            'type' => 'text',
            'instructions' => 'Default title attribute for all static images',
            'default_value' => get_bloginfo('name'),
        ],
        
        // Language flags alt text - individual for each language
        [
            'key' => 'field_language_flags_heading_b2_' . $lang_slug,
            'label' => 'Language Flags Alt Text',
            'type' => 'message',
            'message' => 'Set custom alt text for each language flag',
        ],
        // Get all language flags alt text fields dynamically
        ...array_map(function($flag_lang) use ($lang_slug) {
            return [
                'key' => 'field_flag_' . $flag_lang . '_alt_b2_' . $lang_slug,
                'label' => strtoupper($flag_lang) . ' Flag Alt Text',
                'name' => 'flag_' . $flag_lang . '_alt_b2_' . $lang_slug,
                'type' => 'text',
                'instructions' => 'Alt text for ' . strtoupper($flag_lang) . ' language flag',
                'default_value' => strtoupper($flag_lang) . ' language',
            ];
        }, function_exists('pll_languages_list') ? pll_languages_list() : ['en']),
    ];
}

function get_menu_sub_fields_b2($lang_slug, $prefix) {
    return [
        ['key' => 'field_' . $prefix . '_menu_title_b2_' . $lang_slug, 'label' => 'Title', 'name' => 'title', 'type' => 'text'],
        [
            'key' => 'field_' . $prefix . '_menu_url_b2_' . $lang_slug,
            'label' => 'URL',
            'name' => 'url',
            'type' => 'page_link',
            'post_type' => 'page',
        ],
        [
            'key' => 'field_' . $prefix . '_submenu_b2_' . $lang_slug,
            'label' => 'Submenu',
            'name' => 'submenu',
            'type' => 'repeater',
            'sub_fields' => [
                ['key' => 'field_' . $prefix . '_submenu_title_b2_' . $lang_slug, 'label' => 'Title', 'name' => 'title', 'type' => 'text'],
                [
                    'key' => 'field_' . $prefix . '_submenu_url_b2_' . $lang_slug,
                    'label' => 'URL',
                    'name' => 'url',
                    'type' => 'page_link',
                    'post_type' => 'page',
                ],
            ],
        ],
    ];
}
